/*
 * Decompiled with CFR 0.152.
 */
package de.mennomax.astikorcarts.init;

import de.mennomax.astikorcarts.client.render.RenderCargoCart;
import de.mennomax.astikorcarts.client.render.RenderMobCart;
import de.mennomax.astikorcarts.client.render.RenderPlowCart;
import de.mennomax.astikorcarts.entity.EntityCargoCart;
import de.mennomax.astikorcarts.entity.EntityMobCart;
import de.mennomax.astikorcarts.entity.EntityPlowCart;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@GameRegistry.ObjectHolder(value="astikorcarts")
public class ModEntities {
    public static void registerRenders() {
        RenderingRegistry.registerEntityRenderingHandler(EntityCargoCart.class, RenderCargoCart::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityPlowCart.class, RenderPlowCart::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityMobCart.class, RenderMobCart::new);
    }

    @Mod.EventBusSubscriber(modid="astikorcarts")
    public static class EntityRegistrationHandler {
        private static int id = 0;

        @SubscribeEvent
        public static void registerEntities(RegistryEvent.Register<EntityEntry> event) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])new EntityEntry[]{EntityRegistrationHandler.createEntry(EntityCargoCart.class, "cargocart", 80, 3, false), EntityRegistrationHandler.createEntry(EntityPlowCart.class, "plowcart", 80, 3, false), EntityRegistrationHandler.createEntry(EntityMobCart.class, "mobcart", 80, 3, false)});
        }

        private static EntityEntry createEntry(Class<? extends Entity> entityClass, String name, int trackingRange, int updateFrequency, boolean sendVelocityUpdates) {
            ResourceLocation resourceLocation = new ResourceLocation("astikorcarts", name);
            return EntityEntryBuilder.create().entity(entityClass).id(resourceLocation, id++).name(resourceLocation.toString()).tracker(trackingRange, updateFrequency, sendVelocityUpdates).build();
        }
    }
}

